"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initForNode = void 0;
var node_addon_shared_lib_loader_1 = require("@wontok/node-addon-shared-lib-loader");
var content_filtering_native_api_1 = require("./content-filtering-native-api");
var commands_1 = require("./commands");
var config_1 = __importDefault(require("./config"));
var utils_1 = require("./utils");
//#endregion
var initForNode = function (publicOptions) {
    var initOptions = {
        currentTimestamp: new Date().getTime(),
    };
    var onStateChangeCallback = function (event) {
        var state = {
            secureDataStorePath: "We're in the browser, there's no such thing as a secure data store!",
            blockedCategories: event.payload.blockedCategories,
            isFiltering: event.payload.isFiltering,
            licenceExpirationDate: new Date(event.payload.licenceExpirationTimestamp * 1000),
            nativeServiceAvailable: event.payload.nativeServiceAvailable,
        };
        utils_1.debug("Got new state in public JS Land: " + JSON.stringify(state) + "\n");
        publicOptions.onStateChange(state);
    };
    onStateChangeCallback.callbackName = content_filtering_native_api_1.CallbackNames.onStateChange;
    var onBlockedContentCallback = function (event) {
        var blockedContentInfo = {
            categories: event.payload.categories,
            url: event.payload.url,
        };
        utils_1.debug("Got blocked content in public JS Land: " + JSON.stringify(blockedContentInfo) + "\n");
        publicOptions.onBlockedContent(blockedContentInfo);
    };
    onBlockedContentCallback.callbackName = content_filtering_native_api_1.CallbackNames.onBlockedContent;
    var sharedLibController = node_addon_shared_lib_loader_1.initSharedLib(config_1.default.sharedLib, initOptions, [
        onStateChangeCallback,
        onBlockedContentCallback,
    ]);
    return {
        launchSafeBrowsing: utils_1.launchSafeBrowsing,
        launchGhostpress: function () {
            /* noop */
        },
        terminateGhostpress: function () {
            /* noop */
        },
        getOsName: utils_1.getOsName,
        activateNativeService: function () {
            return sharedLibController.executeCommands([commands_1.commandActivateNativeService()]);
        },
        setBlockedCategories: function (categories) {
            return sharedLibController.executeCommands([
                commands_1.commandSetBlockedCategories(categories),
            ]);
        },
        setWhitelistedDomains: function (domains) {
            return sharedLibController.executeCommands([
                commands_1.commandSetWhitelistedDomains(domains),
            ]);
        },
        setLicenseExpirationDate: function (when) {
            return sharedLibController.executeCommands([
                commands_1.commandSetLicenseExpirationTimestamp(when),
            ]);
        },
        startFiltering: function () {
            return sharedLibController.executeCommands([commands_1.commandStartFiltering()]);
        },
        stopFiltering: function () {
            return sharedLibController.executeCommands([commands_1.commandStopFiltering()]);
        },
        updateTo: function (updateFilePath) {
            return sharedLibController.executeCommands([commands_1.commandUpdateTo(updateFilePath)]);
        },
        unload: sharedLibController.unload,
    };
};
exports.initForNode = initForNode;
